<?php
/**
 * Webstories element option
 *
 * @author : Jegtheme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use JNews\Module\Block\BlockOptionAbstract;

/**
 * Class Element_Userlist_Option
 *
 * @package JNews\Module\Element
 */
class  JNews_Element_Webstories_Option extends BlockOptionAbstract {
	/**
	 * Default number post
	 *
	 * @var int
	 */
	protected $default_number_post = 4;

	/**
	 * Show execrpt
	 *
	 * @var bool
	 */
	protected $show_excerpt = false;

	/**
	 * Default ajax post
	 *
	 * @var int
	 */
	protected $default_ajax_post = 4;

	/**
	 * Compatible column
	 *
	 * @return array compatible column list.
	 */
	public function compatible_column() {
		return array( 4, 6, 12 );
	}

	/**
	 * Set options
	 *
	 * @return void
	 */
	public function set_options() {
		$this->set_content_filter_option( $this->default_number_post );
		$this->set_style_option();
		$this->set_content_setting_option();
	}

	/**
	 * Set content filter option
	 *
	 * @param  mixed $number default number of post to show.
	 * @param  mixed $hide_number_post need to hide number of pos or not.
	 * @return void
	 */
	public function set_content_filter_option( $number = 10, $hide_number_post = false ) {
		$dependency = array(
			'element' => 'sort_by',
			'value'   => array(
				'post_type',
				'latest',
				'oldest',
				'alphabet_asc',
				'alphabet_desc',
				'random',
				'random_week',
				'random_month',
				'most_comment',
				'most_comment_day',
				'most_comment_week',
				'most_comment_month',
				'popular_post_day',
				'popular_post_week',
				'popular_post_month',
				'popular_post',
				'rate',
				'like',
				'share',
			),
		);

		$this->options[] = array(
			'type'        => 'dropdown',
			'param_name'  => 'item_type',
			'std'         => 'circle',
			'heading'     => esc_html__( 'Webstories Item Type', 'jnews-webstories' ),
			'description' => esc_html__( 'Webstories item type', 'jnews-webstories' ),
			'group'       => esc_html__( 'Design', 'jnews' ),
			'value'       => array(
				esc_html__( 'Circle' )  => 'circle',
				esc_html__( 'Square' )  => 'square',
				esc_html__( 'Potrait' ) => 'potrait',
				esc_html__( 'List' )    => 'list',
				esc_html__( 'Grid' )    => 'grid',
			),
		);

		$this->options[] = array(
			'type'        => 'slider',
			'param_name'  => 'number_item',
			'heading'     => esc_html__( 'Number of Item', 'jnews' ),
			'group'       => esc_html__( 'Design', 'jnews' ),
			'description' => esc_html__( 'Set number of story item on each slide.', 'jnews' ),
			'min'         => 1,
			'max'         => 13,
			'step'        => 1,
			'std'         => 11,
			'dependency'  => array(
				'element' => 'item_type',
				'value'   => array( 'circle', 'square' ),
			),
		);

		$this->options[] = array(
			'type'        => 'slider',
			'param_name'  => 'potrait_number_item',
			'heading'     => esc_html__( 'Number of Item', 'jnews' ),
			'group'       => esc_html__( 'Design', 'jnews' ),
			'description' => esc_html__( 'Set number of story item on each slide.', 'jnews' ),
			'min'         => 1,
			'max'         => 8,
			'step'        => 1,
			'std'         => 8,
			'dependency'  => array(
				'element' => 'item_type',
				'value'   => array( 'potrait', 'grid' ),
			),
		);

		$this->options[] = array(
			'type'       => 'dropdown',
			'param_name' => 'sort_by',
			'heading'    => esc_html__( 'Sort by', 'jnews-webstories' ),
			'group'      => esc_html__( 'Content Filter', 'jnews-webstories' ),
			'std'        => 'latest',
			'value'      => array(
				esc_html__( 'Latest story - Published Date', 'jnews-webstories' )           => 'latest',
				esc_html__( 'Latest story - Modified Date', 'jnews-webstories' )            => 'latest_modified',
				esc_html__( 'Oldest story - Published Date', 'jnews-webstories' )           => 'oldest',
				esc_html__( 'Oldest story - Modified Date', 'jnews-webstories' )            => 'oldest_modified',
				esc_html__( 'Alphabet Asc', 'jnews-webstories' )                              => 'alphabet_asc',
				esc_html__( 'Alphabet Desc', 'jnews-webstories' )                             => 'alphabet_desc',
				esc_html__( 'Random Story', 'jnews-webstories' )                            => 'random',
			),
		);

		if ( ! $hide_number_post ) {
			$this->options[] = array(
				'type'        => 'slider',
				'param_name'  => 'number_post',
				'heading'     => esc_html__( 'Number of Story', 'jnews-webstories' ),
				'description' => esc_html__( 'Show number of story on this module.', 'jnews-webstories' ),
				'group'       => esc_html__( 'Content Filter', 'jnews-webstories' ),
				'min'         => 1,
				'max'         => 100,
				'step'        => 1,
				'std'         => $number,
			);
		}

		$this->options[] = array(
			'type'        => 'select',
			'multiple'    => PHP_INT_MAX,
			'param_name'  => 'include_post',
			'heading'     => esc_html__( 'Include Story', 'jnews-webstories' ),
			'description' => esc_html__( 'Select webstories item.', 'jnews-webstories' ),
			'group'       => esc_html__( 'Content Filter', 'jnews' ),
			'std'         => '',
			'value'       => $this->get_webstories(),
		);

		$this->options[] = array(
			'type'        => 'select',
			'multiple'    => PHP_INT_MAX,
			'param_name'  => 'exclude_post',
			'heading'     => esc_html__( 'Exclude Story', 'jnews-webstories' ),
			'description' => esc_html__( 'Select webstories item.', 'jnews-webstories' ),
			'group'       => esc_html__( 'Content Filter', 'jnews-webstories' ),
			'std'         => '',
			'value'       => $this->get_webstories(),
		);

		$this->options[] = array(
			'type'        => 'select',
			'multiple'    => PHP_INT_MAX,
			'ajax'        => 'jeg_find_author',
			'options'     => 'jeg_get_author_option',
			'nonce'       => wp_create_nonce( 'jeg_find_author' ),
			'param_name'  => 'include_author',
			'heading'     => esc_html__( 'Author', 'jnews-webstories' ),
			'description' => esc_html__( 'Write to search post author.', 'jnews-webstories' ),
			'group'       => esc_html__( 'Content Filter', 'jnews-webstories' ),
			'std'         => '',
			'dependency'  => $dependency,
		);

		$this->options[] = array(
			'type'        => 'select',
			'multiple'    => PHP_INT_MAX,
			'ajax'        => 'jnews_webstories_get_category',
			'options'     => array( 'JNews\WEBSTORIES\Helper', 'jnews_webstories_get_category_option' ),
			'nonce'       => wp_create_nonce( 'jeg_find_category' ),
			'param_name'  => 'include_category',
			'heading'     => esc_html__( 'Category', 'jnews' ),
			'description' => esc_html__( 'Add category filter for webstories element.', 'jnews' ),
			'group'       => esc_html__( 'Content Filter', 'jnews-webstories' ),
			'std'         => '',
		);

		$this->options[] = array(
			'type'        => 'select',
			'multiple'    => PHP_INT_MAX,
			'ajax'        => 'jnews_webstories_get_category',
			'options'     => array( 'JNews\WEBSTORIES\Helper', 'jnews_webstories_get_category_option' ),
			'nonce'       => wp_create_nonce( 'jeg_find_category' ),
			'param_name'  => 'exclude_category',
			'heading'     => esc_html__( 'Exclude Category', 'jnews-webstories' ),
			'description' => esc_html__( 'Choose excluded category for this modules.', 'jnews-webstories' ),
			'group'       => esc_html__( 'Content Filter', 'jnews-webstories' ),
			'std'         => '',
		);

		$this->options[] = array(
			'type'        => 'select',
			'multiple'    => PHP_INT_MAX,
			'ajax'        => 'jnews_webstories_get_tag',
			'options'     => array( 'JNews\WEBSTORIES\Helper', 'jnews_webstories_get_tag_option' ),
			'nonce'       => wp_create_nonce( 'jeg_find_tag' ),
			'param_name'  => 'include_tag',
			'heading'     => esc_html__( 'Include Tags', 'jnews' ),
			'description' => esc_html__( 'Add tag filter for webstroies element.', 'jnews-webstories' ),
			'group'       => esc_html__( 'Content Filter', 'jnews-webstories' ),
			'std'         => '',
		);

		$this->options[] = array(
			'type'        => 'select',
			'multiple'    => PHP_INT_MAX,
			'ajax'        => 'jnews_webstories_get_tag',
			'options'     => array( 'JNews\WEBSTORIES\Helper', 'jnews_webstories_get_tag_option' ),
			'nonce'       => wp_create_nonce( 'jeg_find_tag' ),
			'param_name'  => 'exclude_tag',
			'heading'     => esc_html__( 'Exclude Tags', 'jnews-webstories' ),
			'description' => esc_html__( 'Write to search post tag.', 'jnews-webstories' ),
			'group'       => esc_html__( 'Content Filter', 'jnews-webstories' ),
			'std'         => '',
		);

	}

	/**
	 * Set Typography option
	 *
	 * @param \JNews\Elementor\ModuleElementorAbstract $instance Module Elementor Abstract.
	 *
	 * @return boolean
	 */
	public function set_typography_option( $instance ) {
		return false;
	}


	/**
	 * Set style option
	 *
	 * @return void
	 */
	public function set_style_option() {

		$this->options[] = array(
			'type'        => 'checkbox',
			'heading'     => esc_html__( 'Add overlay', 'jnews' ),
			'description' => esc_html__( 'Show overlay on webstory item', 'jnews-webstories' ),
			'group'       => esc_html__( 'Design', 'jnews-webstories' ),
			'param_name'  => 'show_overlay',
		);

		$this->options[] = array(
			'type'        => 'dropdown',
			'param_name'  => 'border_style',
			'heading'     => esc_html__( 'Choose Border Style', 'jnews-webstories' ),
			'description' => esc_html__( 'Choose border style.', 'jnews-webstories' ),
			'group'       => esc_html__( 'Design', 'jnews-webstories' ),
			'std'         => 'solid',
			'value'       => array(
				esc_html__( 'Solid border color', 'jnews-webstories' ) => 'solid',
				esc_html__( 'Gradient border color', 'jnews-webstories' )     => 'gradient',
			),
		);

		$this->options[] = array(
			'type'        => 'colorpicker',
			'param_name'  => 'solid_border_color',
			'std'         => '#ee1f3c',
			'heading'     => esc_html__( 'Story Solid Border Color', 'jnews-webstories' ),
			'description' => esc_html__( 'Choose solid border color for unseen story', 'jnews-webstories' ),
			'group'       => esc_html__( 'Design', 'jnews-webstories' ),
			'dependency'  => array(
				'element' => 'border_style',
				'value'   => array( 'solid' ),
			),
		);

		$this->options[] = array(
			'type'       => 'slider',
			'param_name' => 'border_gradient_degree',
			'heading'    => esc_html__( 'Border Gradient Degree', 'jnews' ),
			'min'        => 0,
			'max'        => 360,
			'step'       => 1,
			'std'        => 180,
			'group'      => esc_html__( 'Design', 'jnews-webstories' ),
			'dependency' => array(
				'element' => 'border_style',
				'value'   => 'gradient',
			),
		);
		$this->options[] = array(
			'type'       => 'colorpicker',
			'std'        => '#F12711',
			'param_name' => 'border_gradient_start_color',
			'heading'    => esc_html__( 'Border Gradient Start Color', 'jnews' ),
			'group'      => esc_html__( 'Design', 'jnews-webstories' ),
			'dependency' => array(
				'element' => 'border_style',
				'value'   => 'gradient',
			),
		);
		$this->options[] = array(
			'type'       => 'colorpicker',
			'std'        => '#F5AF19',
			'param_name' => 'border_gradient_end_color',
			'heading'    => esc_html__( 'Border Gradient End Color', 'jnews' ),
			'group'      => esc_html__( 'Design', 'jnews-webstories' ),
			'dependency' => array(
				'element' => 'border_style',
				'value'   => 'gradient',
			),
		);

		$this->options[] = array(
			'type'        => 'checkbox',
			'heading'     => esc_html__( 'Show Title', 'jnews' ),
			'description' => esc_html__( 'Show Title', 'jnews-webstories' ),
			'group'       => esc_html__( 'Design', 'jnews-webstories' ),
			'param_name'  => 'show_title',
			'std'         => true,
			'dependency'  => array(
				'element' => 'item_type',
				'value'   => array( 'circle', 'square', 'potrait', 'grid' ),
			),
		);

		$this->options[] = array(
			'type'        => 'dropdown',
			'param_name'  => 'show_author',
			'heading'     => esc_html__( 'show author', 'jnews-webstories' ),
			'description' => esc_html__( 'Show author profile picture on', 'jnews-webstories' ),
			'group'       => esc_html__( 'Design', 'jnews-webstories' ),
			'std'         => 'true',
			'value'       => array(
				esc_html__( 'Enable', 'jnews-webstories' ) => 'true',
				esc_html__( 'Disable', 'jnews-webstories' ) => 'false',
			),
			'dependency'  => array(
				'element' => 'item_type',
				'value'   => array( 'potrait', 'grid' ),
			),
		);

		$this->options[] = array(
			'type'        => 'dropdown',
			'param_name'  => 'potrait_style',
			'heading'     => esc_html__( 'Potrait Style', 'jnews-webstories' ),
			'description' => esc_html__( 'Show potrait', 'jnews-webstories' ),
			'group'       => esc_html__( 'Design', 'jnews-webstories' ),
			'std'         => 'style_1',
			'value'       => array(
				esc_html__( 'Potrait style 1', 'jnews-webstories' ) => 'style_1',
				esc_html__( 'Potrait style 2', 'jnews-webstories' ) => 'style_2',
			),
			'dependency'  => array(
				'element' => 'item_type',
				'value'   => array( 'potrait', 'grid' ),
			),
		);

		$this->options[] = array(
			'type'        => 'checkbox',
			'heading'     => esc_html__( 'Show Arrow Controls', 'jnews' ),
			'description' => esc_html__( 'Show Slider Arrow Controls', 'jnews-webstories' ),
			'group'       => esc_html__( 'Design', 'jnews-webstories' ),
			'param_name'  => 'show_controls',
			'dependency'  => array(
				'element' => 'item_type',
				'value'   => array( 'circle', 'square', 'potrait' ),
			),
		);

		$this->options[] = array(
			'type'        => 'slider',
			'param_name'  => 'border_radius',
			'heading'     => esc_html__( 'Border Radius', 'jnews-webstories' ),
			'description' => esc_html__( 'Adjust border radius of this story item.', 'jnews-webstories' ),
			'group'       => esc_html__( 'Design', 'jnews-webstories' ),
			'min'         => 0,
			'max'         => 10,
			'step'        => 1,
			'std'         => 5,
			'dependency'  => array(
				'element' => 'item_type',
				'value'   => array( 'potrait', 'grid' ),
			),
		);

		$this->options[] = array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'heading'    => esc_html__( 'CSS Box', 'jnews' ),
			'group'      => esc_html__( 'Design', 'jnews' ),
		);
	}

	/**
	 * Set content setting option
	 *
	 * @param mixed $show_excerpt show excerpt.
	 * @return void
	 */
	public function set_content_setting_option( $show_excerpt = false ) {
		$this->options[] = array(
			'type'        => 'checkbox',
			'param_name'  => 'force_normal_image_load',
			'heading'     => esc_html__( 'Use Normal Image Load', 'jnews' ),
			'description' => esc_html__( 'Force to use the normal image load for this carousel.', 'jnews' ),
		);
	}

	/**
	 * Set ajax filter option
	 *
	 * @param  mixed $number defalt amount of post to show.
	 * @return void
	 */
	public function set_ajax_filter_option( $number = 10 ) {
		$this->options[] = array(
			'type'        => 'dropdown',
			'param_name'  => 'pagination_mode',
			'heading'     => esc_html__( 'Choose Pagination Mode', 'jnews-webstories' ),
			'description' => esc_html__( 'Choose which pagination mode that fit with your block.', 'jnews-webstories' ),
			'group'       => esc_html__( 'Pagination', 'jnews-webstories' ),
			'std'         => 'disable',
			'value'       => array(
				esc_html__( 'No Pagination', 'jnews-webstories' ) => 'disable',
				esc_html__( 'Next Prev', 'jnews-webstories' )     => 'nextprev',
				esc_html__( 'Load More', 'jnews-webstories' )     => 'loadmore',
				esc_html__( 'Auto Load on Scroll', 'jnews-webstories' ) => 'scrollload',
			),
			'dependency'  => array(
				'element' => 'item_type',
				'value'   => 'list',
			),
		);
		$this->options[] = array(
			'type'       => 'checkbox',
			'param_name' => 'pagination_nextprev_showtext',
			'heading'    => esc_html__( 'Show Navigation Text', 'jnews-webstories' ),
			'value'      => array( esc_html__( 'Show Next/Prev text in the navigation controls.', 'jnews' ) => 'no' ),
			'group'      => esc_html__( 'Pagination', 'jnews-webstories' ),
			'dependency' => array(
				'element' => 'pagination_mode',
				'value'   => array( 'nextprev' ),
			),
		);
		$this->options[] = array(
			'type'        => 'slider',
			'param_name'  => 'pagination_number_post',
			'heading'     => esc_html__( 'Pagination Post', 'jnews-webstories' ),
			'description' => esc_html__( 'Number of Post loaded during pagination request.', 'jnews-webstories' ),
			'group'       => esc_html__( 'Pagination', 'jnews-webstories' ),
			'min'         => 1,
			'max'         => 30,
			'step'        => 1,
			'std'         => $number,
			'dependency'  => array(
				'element' => 'pagination_mode',
				'value'   => array( 'nextprev', 'loadmore', 'scrollload' ),
			),
		);
		$this->options[] = array(
			'type'        => 'number',
			'param_name'  => 'pagination_scroll_limit',
			'heading'     => esc_html__( 'Auto Load Limit', 'jnews-webstories' ),
			'description' => esc_html__( 'Limit of auto load when scrolling, set to zero to always load until end of content.', 'jnews-webstories' ),
			'group'       => esc_html__( 'Pagination', 'jnews-webstories' ),
			'min'         => 0,
			'max'         => 9999,
			'step'        => 1,
			'std'         => 0,
			'dependency'  => array(
				'element' => 'pagination_mode',
				'value'   => array( 'scrollload' ),
			),
		);
	}

	/**
	 * Get module name
	 *
	 * @return string  ELement title
	 */
	public function get_module_name() {
		return esc_html__( 'JNews - Webstories Element', 'jnews-webstories' );
	}

	/**
	 * Get element Category
	 *
	 * @return string element category.
	 */
	public function get_category() {
		return esc_html__( 'JNews - Element', 'jnews-webstories' );
	}

	/**
	 * Get webstories
	 *
	 * @return array web story post list.
	 */
	public function get_webstories() {
		$web_stories = get_posts(
			array(
				'post_type'      => 'web-story',
				'posts_per_page' => -1,
			)
		);

		$stories = array();
		foreach ( $web_stories as $story ) {
			$stories[ $story->post_title ] = $story->ID;
		}
		return $stories;
	}
}
